/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.base.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import io.featureprobe.api.base.cache.ICache;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class MemoryCache<K, V>
implements ICache<K, V> {
    Cache<K, V> defaultCache;

    public MemoryCache() {
        this.defaultCache = CacheBuilder.newBuilder().build();
    }

    private MemoryCache(long weightByte, Weigher<K, V> weigher) {
        this.defaultCache = CacheBuilder.newBuilder().recordStats().maximumWeight(weightByte).weigher(weigher).build();
    }

    public static MemoryCache<String, byte[]> createArrayByteCache(long maxCacheSizeMB) {
        return new MemoryCache<String, byte[]>(maxCacheSizeMB * 1024L * 1024L, (key, value) -> value != null ? ((byte[])value).length : 0);
    }

    @Override
    public Map<K, V> getAll(Iterable<? extends K> var1) {
        return this.defaultCache.getAllPresent(var1);
    }

    @Override
    public V get(K var1) throws ExecutionException {
        return (V)this.defaultCache.getIfPresent(var1);
    }

    @Override
    public void put(K var1, V var2) {
        this.defaultCache.put(var1, var2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> var1) {
        this.defaultCache.putAll(var1);
    }

    @Override
    public void invalidate(K var1) {
        this.defaultCache.invalidate(var1);
    }

    @Override
    public void invalidateAll() {
        this.defaultCache.invalidateAll();
    }
}

