/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.base.enums;

import org.apache.commons.lang3.StringUtils;

public enum SDKType {
    Java("Java"),
    Python("Python"),
    Rust("Rust"),
    Go("Go"),
    NodeJS("Node"),
    Android("Android"),
    Swift("iOS"),
    ObjectiveC("iOS"),
    JavaScript("JS"),
    MiniProgram("MINIPROGRAM"),
    React("REACT"),
    Flutter("flutter");

    private final String value;

    private SDKType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static SDKType fromString(String value) {
        String trimmedValue = StringUtils.trim((String)value).replace(" ", "");
        for (SDKType sdkType : SDKType.values()) {
            if (!sdkType.getValue().equalsIgnoreCase(trimmedValue)) continue;
            return sdkType;
        }
        throw new IllegalArgumentException("Invalid SDKType value: " + value);
    }
}

