/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.featureprobe.sdk.server.model.Condition;
import com.featureprobe.sdk.server.model.ConditionType;
import com.featureprobe.sdk.server.model.PredicateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class ConditionValue {
    @Schema(description="The type of rule.", allowableValues={"string", "number", "semver", "datetime"})
    private String type;
    @Schema(description="Target user attribute name.")
    private String subject;
    @Schema(description="Target user attribute matching rules. <br/> string type allowable values ['is one of', 'ends with', 'starts with', 'contains', 'matches regex', 'is not any of', 'does not end with', 'does not start with', 'does not contain', 'does not match regex']. <br/> number and semver type allowable values ['=', '!=', '>', '>=', '<', '<=', 'between']. <br/> datetime type allowable ['after', 'before', between].")
    private String predicate;
    @Schema(description="Target user attribute matching rules. Incremental Implementation for the 'Between' Rule.<br/> number type allowable values ['>', '>=', '<', '<='], datetime type allowable ['after', 'before'].")
    private String leftPredicate;
    @Schema(description="Target user matching attribute Values.")
    private List<String> objects;
    @Schema(description="Target user attribute matching rules. Incremental Implementation for the 'Between' Rule.<br/> number type allowable values ['>', '>=', '<', '<='], datetime type allowable ['after', 'before'].")
    private String rightPredicate;
    @Schema(description="Target user matching attribute Values.  Incremental Implementation for the 'Between' Rule.")
    private List<String> rightObjects;

    public List<Condition> toCondition() {
        if ("between".equals(this.predicate)) {
            return this.betweenConditionTranslate();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>(1);
        Condition condition = new Condition();
        condition.setType(ConditionType.forValue((String)this.type));
        condition.setSubject(this.subject);
        condition.setPredicate(PredicateType.forValue((String)this.predicate));
        condition.setObjects(this.objects);
        conditions.add(condition);
        return conditions;
    }

    private List<Condition> betweenConditionTranslate() {
        ArrayList<Condition> conditions = new ArrayList<Condition>(2);
        Condition leftConditions = new Condition();
        leftConditions.setType(ConditionType.forValue((String)this.type));
        leftConditions.setSubject(this.subject);
        leftConditions.setPredicate(PredicateType.forValue((String)this.leftPredicate));
        leftConditions.setObjects(this.objects);
        Condition rightConditions = new Condition();
        BeanUtils.copyProperties((Object)leftConditions, (Object)rightConditions);
        rightConditions.setPredicate(PredicateType.forValue((String)this.rightPredicate));
        rightConditions.setObjects(this.rightObjects);
        conditions.add(leftConditions);
        conditions.add(rightConditions);
        return conditions;
    }

    @JsonIgnore
    public boolean isSegmentType() {
        return StringUtils.equals((CharSequence)ConditionType.SEGMENT.toValue(), (CharSequence)this.type);
    }

    @JsonIgnore
    public boolean isNumberType() {
        return StringUtils.equals((CharSequence)ConditionType.NUMBER.toValue(), (CharSequence)this.type);
    }

    @JsonIgnore
    public boolean isDatetimeType() {
        return StringUtils.equals((CharSequence)ConditionType.DATETIME.toValue(), (CharSequence)this.type);
    }

    @JsonIgnore
    public boolean isSemVerType() {
        return StringUtils.equals((CharSequence)ConditionType.SEMVER.toValue(), (CharSequence)this.type);
    }

    @Generated
    public ConditionValue() {
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getPredicate() {
        return this.predicate;
    }

    @Generated
    public String getLeftPredicate() {
        return this.leftPredicate;
    }

    @Generated
    public List<String> getObjects() {
        return this.objects;
    }

    @Generated
    public String getRightPredicate() {
        return this.rightPredicate;
    }

    @Generated
    public List<String> getRightObjects() {
        return this.rightObjects;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    @Generated
    public void setLeftPredicate(String leftPredicate) {
        this.leftPredicate = leftPredicate;
    }

    @Generated
    public void setObjects(List<String> objects) {
        this.objects = objects;
    }

    @Generated
    public void setRightPredicate(String rightPredicate) {
        this.rightPredicate = rightPredicate;
    }

    @Generated
    public void setRightObjects(List<String> rightObjects) {
        this.rightObjects = rightObjects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionValue)) {
            return false;
        }
        ConditionValue other = (ConditionValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$predicate = this.getPredicate();
        String other$predicate = other.getPredicate();
        if (this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate)) {
            return false;
        }
        String this$leftPredicate = this.getLeftPredicate();
        String other$leftPredicate = other.getLeftPredicate();
        if (this$leftPredicate == null ? other$leftPredicate != null : !this$leftPredicate.equals(other$leftPredicate)) {
            return false;
        }
        List<String> this$objects = this.getObjects();
        List<String> other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects)) {
            return false;
        }
        String this$rightPredicate = this.getRightPredicate();
        String other$rightPredicate = other.getRightPredicate();
        if (this$rightPredicate == null ? other$rightPredicate != null : !this$rightPredicate.equals(other$rightPredicate)) {
            return false;
        }
        List<String> this$rightObjects = this.getRightObjects();
        List<String> other$rightObjects = other.getRightObjects();
        return !(this$rightObjects == null ? other$rightObjects != null : !((Object)this$rightObjects).equals(other$rightObjects));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConditionValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $predicate = this.getPredicate();
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        String $leftPredicate = this.getLeftPredicate();
        result = result * 59 + ($leftPredicate == null ? 43 : $leftPredicate.hashCode());
        List<String> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        String $rightPredicate = this.getRightPredicate();
        result = result * 59 + ($rightPredicate == null ? 43 : $rightPredicate.hashCode());
        List<String> $rightObjects = this.getRightObjects();
        result = result * 59 + ($rightObjects == null ? 43 : ((Object)$rightObjects).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConditionValue(type=" + this.getType() + ", subject=" + this.getSubject() + ", predicate=" + this.getPredicate() + ", leftPredicate=" + this.getLeftPredicate() + ", objects=" + this.getObjects() + ", rightPredicate=" + this.getRightPredicate() + ", rightObjects=" + this.getRightObjects() + ")";
    }
}

