/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.featureprobe.sdk.server.model.Serve;
import com.featureprobe.sdk.server.model.Split;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="Define the return value. <br/> Just provide one of 'select' and 'split'. ")
public class ServeValue {
    @Schema(description="Define the return variation index.")
    private Integer select;
    @Schema(description="Variations rollout by percentage. <br/> Accuracy is ten thousand. <br/> Example: [5000, 5000] means the percentages are 50% each.")
    private List<Integer> split;

    ServeValue(Integer select) {
        this.select = select;
    }

    ServeValue(List<Integer> split) {
        this.split = split;
    }

    public static ServeValue createSelect(Integer select) {
        return new ServeValue(select);
    }

    public static ServeValue createSplit(List<Integer> split) {
        return new ServeValue(split);
    }

    public Serve toServe() {
        if (this.isSplitServe()) {
            return new Serve(this.toDistributionSplit());
        }
        if (this.getSelect() != null) {
            return new Serve(this.getSelect());
        }
        return null;
    }

    @JsonIgnore
    protected boolean isSplitServe() {
        return this.split != null && this.split.size() > 0;
    }

    protected Split toDistributionSplit() {
        if (!this.isSplitServe()) {
            return null;
        }
        ArrayList distribution = Lists.newArrayList();
        int end = 0;
        for (int i = 0; i < this.split.size(); ++i) {
            int start = end;
            distribution.add(this.makePairs(start, end += this.split.get(i).intValue()));
        }
        return new Split((List)distribution);
    }

    private List<List<Integer>> makePairs(Integer start, Integer end) {
        ArrayList pairs = Lists.newArrayList();
        pairs.add(Lists.newArrayList((Object[])new Integer[]{start, end}));
        return pairs;
    }

    @Generated
    public Integer getSelect() {
        return this.select;
    }

    @Generated
    public List<Integer> getSplit() {
        return this.split;
    }

    @Generated
    public void setSelect(Integer select) {
        this.select = select;
    }

    @Generated
    public void setSplit(List<Integer> split) {
        this.split = split;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServeValue)) {
            return false;
        }
        ServeValue other = (ServeValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$select = this.getSelect();
        Integer other$select = other.getSelect();
        if (this$select == null ? other$select != null : !((Object)this$select).equals(other$select)) {
            return false;
        }
        List<Integer> this$split = this.getSplit();
        List<Integer> other$split = other.getSplit();
        return !(this$split == null ? other$split != null : !((Object)this$split).equals(other$split));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServeValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $select = this.getSelect();
        result = result * 59 + ($select == null ? 43 : ((Object)$select).hashCode());
        List<Integer> $split = this.getSplit();
        result = result * 59 + ($split == null ? 43 : ((Object)$split).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServeValue(select=" + this.getSelect() + ", split=" + this.getSplit() + ")";
    }

    @Generated
    public ServeValue() {
    }
}

