/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.base.model;

import com.featureprobe.sdk.server.model.Prerequisite;
import io.featureprobe.api.base.model.PrerequisiteModel;
import io.featureprobe.api.base.model.ServeValue;
import io.featureprobe.api.base.model.ToggleRule;
import io.featureprobe.api.base.model.Variation;
import io.featureprobe.api.base.util.JsonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(description="This is where you can express complex rules on attributes with conditions and operators. <br/> rules\u3001disabledServe\u3001defaultServe\u3001variations support independent update.")
public class TargetingContent {
    @Schema(description="Server a variation to specific users based on their attributes. <br/> **Use OR(|) operation between multiple rules.**")
    private List<ToggleRule> rules;
    @NotNull
    private ServeValue disabledServe;
    @NotNull
    private ServeValue defaultServe;
    @Schema(description="Variations decide the toggles return value in you code.")
    @NotNull
    private List<Variation> variations;
    @Schema(description="Precondition for toggle.")
    @NotNull
    private List<PrerequisiteModel> prerequisites;

    public static TargetingContent newDefault(String variations, Integer disabledServe) {
        TargetingContent toggleContentModel = new TargetingContent();
        toggleContentModel.setRules(new ArrayList<ToggleRule>());
        toggleContentModel.setVariations(JsonMapper.toListObject(variations, Variation.class));
        toggleContentModel.setDisabledServe(ServeValue.createSelect(disabledServe));
        toggleContentModel.setDefaultServe(new ServeValue());
        toggleContentModel.setPrerequisites(Collections.emptyList());
        return toggleContentModel;
    }

    public String toJson() {
        return JsonMapper.toJSONString(this);
    }

    public List<Object> getVariationObjectsByConverter(Variation.ValueConverter variationValueConverter) {
        return this.variations.stream().map(variation -> variationValueConverter.convert(variation.getValue())).collect(Collectors.toList());
    }

    public List<Prerequisite> getPrerequisiteByConverter(Map<String, Variation.ValueConverter<?>> converters) {
        if (Objects.isNull(this.prerequisites)) {
            return Collections.emptyList();
        }
        return this.prerequisites.stream().map(prerequisiteModel -> this.buildSdkPrerequisite((Variation.ValueConverter)converters.get(prerequisiteModel.getType()), (PrerequisiteModel)prerequisiteModel)).collect(Collectors.toList());
    }

    private Prerequisite buildSdkPrerequisite(Variation.ValueConverter variationValueConverter, PrerequisiteModel prerequisiteModel) {
        Prerequisite prerequisite = new Prerequisite();
        prerequisite.setKey(prerequisiteModel.getKey());
        prerequisite.setValue(variationValueConverter.convert(prerequisiteModel.getValue()));
        return prerequisite;
    }

    @Generated
    public TargetingContent() {
    }

    @Generated
    public List<ToggleRule> getRules() {
        return this.rules;
    }

    @Generated
    public ServeValue getDisabledServe() {
        return this.disabledServe;
    }

    @Generated
    public ServeValue getDefaultServe() {
        return this.defaultServe;
    }

    @Generated
    public List<Variation> getVariations() {
        return this.variations;
    }

    @Generated
    public List<PrerequisiteModel> getPrerequisites() {
        return this.prerequisites;
    }

    @Generated
    public void setRules(List<ToggleRule> rules) {
        this.rules = rules;
    }

    @Generated
    public void setDisabledServe(ServeValue disabledServe) {
        this.disabledServe = disabledServe;
    }

    @Generated
    public void setDefaultServe(ServeValue defaultServe) {
        this.defaultServe = defaultServe;
    }

    @Generated
    public void setVariations(List<Variation> variations) {
        this.variations = variations;
    }

    @Generated
    public void setPrerequisites(List<PrerequisiteModel> prerequisites) {
        this.prerequisites = prerequisites;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetingContent)) {
            return false;
        }
        TargetingContent other = (TargetingContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ToggleRule> this$rules = this.getRules();
        List<ToggleRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        ServeValue this$disabledServe = this.getDisabledServe();
        ServeValue other$disabledServe = other.getDisabledServe();
        if (this$disabledServe == null ? other$disabledServe != null : !((Object)this$disabledServe).equals(other$disabledServe)) {
            return false;
        }
        ServeValue this$defaultServe = this.getDefaultServe();
        ServeValue other$defaultServe = other.getDefaultServe();
        if (this$defaultServe == null ? other$defaultServe != null : !((Object)this$defaultServe).equals(other$defaultServe)) {
            return false;
        }
        List<Variation> this$variations = this.getVariations();
        List<Variation> other$variations = other.getVariations();
        if (this$variations == null ? other$variations != null : !((Object)this$variations).equals(other$variations)) {
            return false;
        }
        List<PrerequisiteModel> this$prerequisites = this.getPrerequisites();
        List<PrerequisiteModel> other$prerequisites = other.getPrerequisites();
        return !(this$prerequisites == null ? other$prerequisites != null : !((Object)this$prerequisites).equals(other$prerequisites));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TargetingContent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ToggleRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        ServeValue $disabledServe = this.getDisabledServe();
        result = result * 59 + ($disabledServe == null ? 43 : ((Object)$disabledServe).hashCode());
        ServeValue $defaultServe = this.getDefaultServe();
        result = result * 59 + ($defaultServe == null ? 43 : ((Object)$defaultServe).hashCode());
        List<Variation> $variations = this.getVariations();
        result = result * 59 + ($variations == null ? 43 : ((Object)$variations).hashCode());
        List<PrerequisiteModel> $prerequisites = this.getPrerequisites();
        result = result * 59 + ($prerequisites == null ? 43 : ((Object)$prerequisites).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TargetingContent(rules=" + this.getRules() + ", disabledServe=" + this.getDisabledServe() + ", defaultServe=" + this.getDefaultServe() + ", variations=" + this.getVariations() + ", prerequisites=" + this.getPrerequisites() + ")";
    }
}

