/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.base.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JsonMapper {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJSONString(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String content, Class<T> valueType) {
        try {
            if (StringUtils.isBlank((CharSequence)content)) {
                return null;
            }
            return (T)mapper.readValue(content, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> toListObject(String content, Class<T> valueType) {
        try {
            if (StringUtils.isBlank((CharSequence)content)) {
                return Collections.emptyList();
            }
            return (List)mapper.readValue(content, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, valueType));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

