/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.base.util;

import org.apache.commons.lang3.StringUtils;

public class ToggleContentLimitChecker {
    private static final long DEFAULT_MAX_LENGTH = 0x100000L;

    public static boolean isOverLimitSize(String content, long maxLength) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        try {
            return (long)content.getBytes().length > maxLength;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isOverLimitSize(String content) {
        return ToggleContentLimitChecker.isOverLimitSize(content, 0x100000L);
    }

    public static void validateSize(String content) {
        if (ToggleContentLimitChecker.isOverLimitSize(content)) {
            throw new IllegalArgumentException("validate.targeting_content_over_limit");
        }
    }
}

