/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.dao.entity.Member;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
public abstract class AbstractAuditEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false, updatable=false)
    @CreatedDate
    private Date createdTime;
    @CreatedBy
    @ManyToOne
    @JoinColumn(name="created_by", referencedColumnName="id", nullable=false, updatable=false)
    private Member createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="modified_time", nullable=false)
    @LastModifiedDate
    private Date modifiedTime;
    @LastModifiedBy
    @ManyToOne
    @JoinColumn(name="modified_by", referencedColumnName="id", nullable=false)
    private Member modifiedBy;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAuditEntity that = (AbstractAuditEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.modifiedTime, that.modifiedTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdTime, this.modifiedTime);
    }

    public String toString() {
        return "AbstractAuditEntity{id=" + this.id + ", createdTime=" + this.createdTime + ", modifiedTime=" + this.modifiedTime + '}';
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Member getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    @Generated
    public Member getModifiedBy() {
        return this.modifiedBy;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setCreatedBy(Member createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    @Generated
    public void setModifiedBy(Member modifiedBy) {
        this.modifiedBy = modifiedBy;
    }
}

