/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.AccessTokenType;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="access_token")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDefs(value={@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")}), @FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")})})
@Filters(value={@Filter(name="tenantFilter", condition="organization_id = :organizationId"), @Filter(name="deletedFilter", condition="deleted = :deleted")})
public class AccessToken
extends AbstractAuditEntity
implements TenantSupport,
Serializable {
    private String name;
    @Enumerated(value=EnumType.STRING)
    private OrganizationRoleEnum role;
    @Column(name="member_id")
    private Long memberId;
    @Column(columnDefinition="TINYINT")
    private boolean deleted;
    @Column(name="organization_id")
    private Long organizationId;
    private String token;
    @Enumerated(value=EnumType.STRING)
    @Column(name="[type]")
    private AccessTokenType type;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="visited_time")
    private Date visitedTime;

    @Generated
    public static AccessTokenBuilder builder() {
        return new AccessTokenBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessToken)) {
            return false;
        }
        AccessToken other = (AccessToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$memberId = this.getMemberId();
        Long other$memberId = other.getMemberId();
        if (this$memberId == null ? other$memberId != null : !((Object)this$memberId).equals(other$memberId)) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        OrganizationRoleEnum this$role = this.getRole();
        OrganizationRoleEnum other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        AccessTokenType this$type = this.getType();
        AccessTokenType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$visitedTime = this.getVisitedTime();
        Date other$visitedTime = other.getVisitedTime();
        return !(this$visitedTime == null ? other$visitedTime != null : !((Object)this$visitedTime).equals(other$visitedTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccessToken;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $memberId = this.getMemberId();
        result = result * 59 + ($memberId == null ? 43 : ((Object)$memberId).hashCode());
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        OrganizationRoleEnum $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        AccessTokenType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $visitedTime = this.getVisitedTime();
        result = result * 59 + ($visitedTime == null ? 43 : ((Object)$visitedTime).hashCode());
        return result;
    }

    @Generated
    public AccessToken() {
    }

    @Generated
    public AccessToken(String name, OrganizationRoleEnum role, Long memberId, boolean deleted, Long organizationId, String token, AccessTokenType type, Date visitedTime) {
        this.name = name;
        this.role = role;
        this.memberId = memberId;
        this.deleted = deleted;
        this.organizationId = organizationId;
        this.token = token;
        this.type = type;
        this.visitedTime = visitedTime;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public OrganizationRoleEnum getRole() {
        return this.role;
    }

    @Generated
    public Long getMemberId() {
        return this.memberId;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public AccessTokenType getType() {
        return this.type;
    }

    @Generated
    public Date getVisitedTime() {
        return this.visitedTime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRole(OrganizationRoleEnum role) {
        this.role = role;
    }

    @Generated
    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setType(AccessTokenType type) {
        this.type = type;
    }

    @Generated
    public void setVisitedTime(Date visitedTime) {
        this.visitedTime = visitedTime;
    }

    @Override
    @Generated
    public String toString() {
        return "AccessToken(super=" + super.toString() + ", name=" + this.getName() + ", role=" + this.getRole() + ", memberId=" + this.getMemberId() + ", deleted=" + this.isDeleted() + ", organizationId=" + this.getOrganizationId() + ", token=" + this.getToken() + ", type=" + this.getType() + ", visitedTime=" + this.getVisitedTime() + ")";
    }

    @Generated
    public static class AccessTokenBuilder {
        @Generated
        private String name;
        @Generated
        private OrganizationRoleEnum role;
        @Generated
        private Long memberId;
        @Generated
        private boolean deleted;
        @Generated
        private Long organizationId;
        @Generated
        private String token;
        @Generated
        private AccessTokenType type;
        @Generated
        private Date visitedTime;

        @Generated
        AccessTokenBuilder() {
        }

        @Generated
        public AccessTokenBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public AccessTokenBuilder role(OrganizationRoleEnum role) {
            this.role = role;
            return this;
        }

        @Generated
        public AccessTokenBuilder memberId(Long memberId) {
            this.memberId = memberId;
            return this;
        }

        @Generated
        public AccessTokenBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public AccessTokenBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public AccessTokenBuilder token(String token) {
            this.token = token;
            return this;
        }

        @Generated
        public AccessTokenBuilder type(AccessTokenType type) {
            this.type = type;
            return this;
        }

        @Generated
        public AccessTokenBuilder visitedTime(Date visitedTime) {
            this.visitedTime = visitedTime;
            return this;
        }

        @Generated
        public AccessToken build() {
            return new AccessToken(this.name, this.role, this.memberId, this.deleted, this.organizationId, this.token, this.type, this.visitedTime);
        }

        @Generated
        public String toString() {
            return "AccessToken.AccessTokenBuilder(name=" + this.name + ", role=" + this.role + ", memberId=" + this.memberId + ", deleted=" + this.deleted + ", organizationId=" + this.organizationId + ", token=" + this.token + ", type=" + this.type + ", visitedTime=" + this.visitedTime + ")";
        }
    }
}

