/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.ApprovalStatusEnum;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="approval_record")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")})
@Filter(name="tenantFilter", condition="organization_id = :organizationId")
public class ApprovalRecord
extends AbstractAuditEntity
implements TenantSupport,
Serializable {
    @Column(name="organization_id")
    private Long organizationId;
    @Column(name="project_key")
    private String projectKey;
    @Column(name="environment_key")
    private String environmentKey;
    @Column(name="toggle_key")
    private String toggleKey;
    private String submitBy;
    private String approvedBy;
    @Column(name="reviewers")
    private String reviewers;
    @Enumerated(value=EnumType.STRING)
    private ApprovalStatusEnum status;
    private String title;
    @Column(columnDefinition="TEXT")
    private String comment;

    public String environmentUniqueKey() {
        return this.projectKey + "&" + this.environmentKey;
    }

    public String toggleUniqueKey() {
        return this.projectKey + "&" + this.toggleKey;
    }

    @Generated
    public static ApprovalRecordBuilder builder() {
        return new ApprovalRecordBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApprovalRecord)) {
            return false;
        }
        ApprovalRecord other = (ApprovalRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
            return false;
        }
        String this$environmentKey = this.getEnvironmentKey();
        String other$environmentKey = other.getEnvironmentKey();
        if (this$environmentKey == null ? other$environmentKey != null : !this$environmentKey.equals(other$environmentKey)) {
            return false;
        }
        String this$toggleKey = this.getToggleKey();
        String other$toggleKey = other.getToggleKey();
        if (this$toggleKey == null ? other$toggleKey != null : !this$toggleKey.equals(other$toggleKey)) {
            return false;
        }
        String this$submitBy = this.getSubmitBy();
        String other$submitBy = other.getSubmitBy();
        if (this$submitBy == null ? other$submitBy != null : !this$submitBy.equals(other$submitBy)) {
            return false;
        }
        String this$approvedBy = this.getApprovedBy();
        String other$approvedBy = other.getApprovedBy();
        if (this$approvedBy == null ? other$approvedBy != null : !this$approvedBy.equals(other$approvedBy)) {
            return false;
        }
        String this$reviewers = this.getReviewers();
        String other$reviewers = other.getReviewers();
        if (this$reviewers == null ? other$reviewers != null : !this$reviewers.equals(other$reviewers)) {
            return false;
        }
        ApprovalStatusEnum this$status = this.getStatus();
        ApprovalStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApprovalRecord;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        String $environmentKey = this.getEnvironmentKey();
        result = result * 59 + ($environmentKey == null ? 43 : $environmentKey.hashCode());
        String $toggleKey = this.getToggleKey();
        result = result * 59 + ($toggleKey == null ? 43 : $toggleKey.hashCode());
        String $submitBy = this.getSubmitBy();
        result = result * 59 + ($submitBy == null ? 43 : $submitBy.hashCode());
        String $approvedBy = this.getApprovedBy();
        result = result * 59 + ($approvedBy == null ? 43 : $approvedBy.hashCode());
        String $reviewers = this.getReviewers();
        result = result * 59 + ($reviewers == null ? 43 : $reviewers.hashCode());
        ApprovalStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @Generated
    public ApprovalRecord() {
    }

    @Generated
    public ApprovalRecord(Long organizationId, String projectKey, String environmentKey, String toggleKey, String submitBy, String approvedBy, String reviewers, ApprovalStatusEnum status, String title, String comment) {
        this.organizationId = organizationId;
        this.projectKey = projectKey;
        this.environmentKey = environmentKey;
        this.toggleKey = toggleKey;
        this.submitBy = submitBy;
        this.approvedBy = approvedBy;
        this.reviewers = reviewers;
        this.status = status;
        this.title = title;
        this.comment = comment;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Generated
    public String getToggleKey() {
        return this.toggleKey;
    }

    @Generated
    public String getSubmitBy() {
        return this.submitBy;
    }

    @Generated
    public String getApprovedBy() {
        return this.approvedBy;
    }

    @Generated
    public String getReviewers() {
        return this.reviewers;
    }

    @Generated
    public ApprovalStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    @Generated
    public void setToggleKey(String toggleKey) {
        this.toggleKey = toggleKey;
    }

    @Generated
    public void setSubmitBy(String submitBy) {
        this.submitBy = submitBy;
    }

    @Generated
    public void setApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
    }

    @Generated
    public void setReviewers(String reviewers) {
        this.reviewers = reviewers;
    }

    @Generated
    public void setStatus(ApprovalStatusEnum status) {
        this.status = status;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    @Generated
    public String toString() {
        return "ApprovalRecord(super=" + super.toString() + ", organizationId=" + this.getOrganizationId() + ", projectKey=" + this.getProjectKey() + ", environmentKey=" + this.getEnvironmentKey() + ", toggleKey=" + this.getToggleKey() + ", submitBy=" + this.getSubmitBy() + ", approvedBy=" + this.getApprovedBy() + ", reviewers=" + this.getReviewers() + ", status=" + this.getStatus() + ", title=" + this.getTitle() + ", comment=" + this.getComment() + ")";
    }

    @Generated
    public static class ApprovalRecordBuilder {
        @Generated
        private Long organizationId;
        @Generated
        private String projectKey;
        @Generated
        private String environmentKey;
        @Generated
        private String toggleKey;
        @Generated
        private String submitBy;
        @Generated
        private String approvedBy;
        @Generated
        private String reviewers;
        @Generated
        private ApprovalStatusEnum status;
        @Generated
        private String title;
        @Generated
        private String comment;

        @Generated
        ApprovalRecordBuilder() {
        }

        @Generated
        public ApprovalRecordBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder environmentKey(String environmentKey) {
            this.environmentKey = environmentKey;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder toggleKey(String toggleKey) {
            this.toggleKey = toggleKey;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder submitBy(String submitBy) {
            this.submitBy = submitBy;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder approvedBy(String approvedBy) {
            this.approvedBy = approvedBy;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder reviewers(String reviewers) {
            this.reviewers = reviewers;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder status(ApprovalStatusEnum status) {
            this.status = status;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public ApprovalRecordBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public ApprovalRecord build() {
            return new ApprovalRecord(this.organizationId, this.projectKey, this.environmentKey, this.toggleKey, this.submitBy, this.approvedBy, this.reviewers, this.status, this.title, this.comment);
        }

        @Generated
        public String toString() {
            return "ApprovalRecord.ApprovalRecordBuilder(organizationId=" + this.organizationId + ", projectKey=" + this.projectKey + ", environmentKey=" + this.environmentKey + ", toggleKey=" + this.toggleKey + ", submitBy=" + this.submitBy + ", approvedBy=" + this.approvedBy + ", reviewers=" + this.reviewers + ", status=" + this.status + ", title=" + this.title + ", comment=" + this.comment + ")";
        }
    }
}

