/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Project;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="environment")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDefs(value={@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")}), @FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")}), @FilterDef(name="archivedFilter", parameters={@ParamDef(name="archived", type="boolean")})})
@Filters(value={@Filter(name="tenantFilter", condition="organization_id = :organizationId"), @Filter(name="deletedFilter", condition="deleted = :deleted"), @Filter(name="archivedFilter", condition="archived = :archived")})
public class Environment
extends AbstractAuditEntity
implements TenantSupport,
Serializable {
    private String name;
    @Column(name="[key]")
    private String key;
    @Column(name="server_sdk_key")
    private String serverSdkKey;
    @Column(name="client_sdk_key")
    private String clientSdkKey;
    private Long version;
    @Column(columnDefinition="BIT", length=1)
    private boolean deleted;
    @Column(columnDefinition="BIT", length=1)
    private boolean archived;
    @Column(name="enable_approval", columnDefinition="BIT", length=1)
    private boolean enableApproval;
    @Column(name="debugger_until_time", columnDefinition="BIGINT")
    private Long debuggerUntilTime;
    private String reviewers;
    @ManyToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(column=@JoinColumn(name="organization_id", referencedColumnName="organization_id")), @JoinColumnOrFormula(column=@JoinColumn(name="project_key", referencedColumnName="key"))})
    private Project project;

    @Override
    public Long getOrganizationId() {
        return this.project.getOrganizationId();
    }

    @Override
    public void setOrganizationId(Long organizationId) {
        this.project.setOrganizationId(organizationId);
    }

    public String uniqueKey() {
        return this.project.getKey() + "&" + this.key;
    }

    @Generated
    public static EnvironmentBuilder builder() {
        return new EnvironmentBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.isArchived() != other.isArchived()) {
            return false;
        }
        if (this.isEnableApproval() != other.isEnableApproval()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$debuggerUntilTime = this.getDebuggerUntilTime();
        Long other$debuggerUntilTime = other.getDebuggerUntilTime();
        if (this$debuggerUntilTime == null ? other$debuggerUntilTime != null : !((Object)this$debuggerUntilTime).equals(other$debuggerUntilTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$serverSdkKey = this.getServerSdkKey();
        String other$serverSdkKey = other.getServerSdkKey();
        if (this$serverSdkKey == null ? other$serverSdkKey != null : !this$serverSdkKey.equals(other$serverSdkKey)) {
            return false;
        }
        String this$clientSdkKey = this.getClientSdkKey();
        String other$clientSdkKey = other.getClientSdkKey();
        if (this$clientSdkKey == null ? other$clientSdkKey != null : !this$clientSdkKey.equals(other$clientSdkKey)) {
            return false;
        }
        String this$reviewers = this.getReviewers();
        String other$reviewers = other.getReviewers();
        return !(this$reviewers == null ? other$reviewers != null : !this$reviewers.equals(other$reviewers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        result = result * 59 + (this.isArchived() ? 79 : 97);
        result = result * 59 + (this.isEnableApproval() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $debuggerUntilTime = this.getDebuggerUntilTime();
        result = result * 59 + ($debuggerUntilTime == null ? 43 : ((Object)$debuggerUntilTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $serverSdkKey = this.getServerSdkKey();
        result = result * 59 + ($serverSdkKey == null ? 43 : $serverSdkKey.hashCode());
        String $clientSdkKey = this.getClientSdkKey();
        result = result * 59 + ($clientSdkKey == null ? 43 : $clientSdkKey.hashCode());
        String $reviewers = this.getReviewers();
        result = result * 59 + ($reviewers == null ? 43 : $reviewers.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Environment(super=" + super.toString() + ", name=" + this.getName() + ", key=" + this.getKey() + ", serverSdkKey=" + this.getServerSdkKey() + ", clientSdkKey=" + this.getClientSdkKey() + ", version=" + this.getVersion() + ", deleted=" + this.isDeleted() + ", archived=" + this.isArchived() + ", enableApproval=" + this.isEnableApproval() + ", debuggerUntilTime=" + this.getDebuggerUntilTime() + ", reviewers=" + this.getReviewers() + ")";
    }

    @Generated
    public Environment() {
    }

    @Generated
    public Environment(String name, String key, String serverSdkKey, String clientSdkKey, Long version, boolean deleted, boolean archived, boolean enableApproval, Long debuggerUntilTime, String reviewers, Project project) {
        this.name = name;
        this.key = key;
        this.serverSdkKey = serverSdkKey;
        this.clientSdkKey = clientSdkKey;
        this.version = version;
        this.deleted = deleted;
        this.archived = archived;
        this.enableApproval = enableApproval;
        this.debuggerUntilTime = debuggerUntilTime;
        this.reviewers = reviewers;
        this.project = project;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getServerSdkKey() {
        return this.serverSdkKey;
    }

    @Generated
    public String getClientSdkKey() {
        return this.clientSdkKey;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public boolean isArchived() {
        return this.archived;
    }

    @Generated
    public boolean isEnableApproval() {
        return this.enableApproval;
    }

    @Generated
    public Long getDebuggerUntilTime() {
        return this.debuggerUntilTime;
    }

    @Generated
    public String getReviewers() {
        return this.reviewers;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setServerSdkKey(String serverSdkKey) {
        this.serverSdkKey = serverSdkKey;
    }

    @Generated
    public void setClientSdkKey(String clientSdkKey) {
        this.clientSdkKey = clientSdkKey;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    @Generated
    public void setEnableApproval(boolean enableApproval) {
        this.enableApproval = enableApproval;
    }

    @Generated
    public void setDebuggerUntilTime(Long debuggerUntilTime) {
        this.debuggerUntilTime = debuggerUntilTime;
    }

    @Generated
    public void setReviewers(String reviewers) {
        this.reviewers = reviewers;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public static class EnvironmentBuilder {
        @Generated
        private String name;
        @Generated
        private String key;
        @Generated
        private String serverSdkKey;
        @Generated
        private String clientSdkKey;
        @Generated
        private Long version;
        @Generated
        private boolean deleted;
        @Generated
        private boolean archived;
        @Generated
        private boolean enableApproval;
        @Generated
        private Long debuggerUntilTime;
        @Generated
        private String reviewers;
        @Generated
        private Project project;

        @Generated
        EnvironmentBuilder() {
        }

        @Generated
        public EnvironmentBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public EnvironmentBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public EnvironmentBuilder serverSdkKey(String serverSdkKey) {
            this.serverSdkKey = serverSdkKey;
            return this;
        }

        @Generated
        public EnvironmentBuilder clientSdkKey(String clientSdkKey) {
            this.clientSdkKey = clientSdkKey;
            return this;
        }

        @Generated
        public EnvironmentBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public EnvironmentBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public EnvironmentBuilder archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        @Generated
        public EnvironmentBuilder enableApproval(boolean enableApproval) {
            this.enableApproval = enableApproval;
            return this;
        }

        @Generated
        public EnvironmentBuilder debuggerUntilTime(Long debuggerUntilTime) {
            this.debuggerUntilTime = debuggerUntilTime;
            return this;
        }

        @Generated
        public EnvironmentBuilder reviewers(String reviewers) {
            this.reviewers = reviewers;
            return this;
        }

        @Generated
        public EnvironmentBuilder project(Project project) {
            this.project = project;
            return this;
        }

        @Generated
        public Environment build() {
            return new Environment(this.name, this.key, this.serverSdkKey, this.clientSdkKey, this.version, this.deleted, this.archived, this.enableApproval, this.debuggerUntilTime, this.reviewers, this.project);
        }

        @Generated
        public String toString() {
            return "Environment.EnvironmentBuilder(name=" + this.name + ", key=" + this.key + ", serverSdkKey=" + this.serverSdkKey + ", clientSdkKey=" + this.clientSdkKey + ", version=" + this.version + ", deleted=" + this.deleted + ", archived=" + this.archived + ", enableApproval=" + this.enableApproval + ", debuggerUntilTime=" + this.debuggerUntilTime + ", reviewers=" + this.reviewers + ", project=" + this.project + ")";
        }
    }
}

