/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.EventTypeEnum;
import io.featureprobe.api.base.enums.MatcherTypeEnum;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="event")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")})
@Filter(name="tenantFilter", condition="organization_id = :organizationId")
public class Event
extends AbstractAuditEntity
implements TenantSupport,
Comparable<Event> {
    @Column(name="organization_id")
    private Long organizationId;
    private String name;
    @Enumerated(value=EnumType.STRING)
    private EventTypeEnum type;
    @Enumerated(value=EnumType.STRING)
    private MatcherTypeEnum matcher;
    @Column(columnDefinition="TEXT")
    private String url;
    @Column(columnDefinition="TEXT")
    private String selector;

    public Event(EventTypeEnum type, String name, MatcherTypeEnum matcher, String url) {
        this.type = type;
        this.name = name;
        this.matcher = matcher;
        this.url = url;
    }

    public Event(EventTypeEnum type, String name, MatcherTypeEnum matcher, String url, String selector) {
        this.type = type;
        this.name = name;
        this.matcher = matcher;
        this.url = url;
        this.selector = selector;
    }

    @Override
    public int compareTo(Event o) {
        if (this.name.equals(o.name)) {
            return 0;
        }
        return -1;
    }

    @Generated
    public static EventBuilder builder() {
        return new EventBuilder();
    }

    @Generated
    public Event() {
    }

    @Generated
    public Event(Long organizationId, String name, EventTypeEnum type, MatcherTypeEnum matcher, String url, String selector) {
        this.organizationId = organizationId;
        this.name = name;
        this.type = type;
        this.matcher = matcher;
        this.url = url;
        this.selector = selector;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public EventTypeEnum getType() {
        return this.type;
    }

    @Generated
    public MatcherTypeEnum getMatcher() {
        return this.matcher;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getSelector() {
        return this.selector;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(EventTypeEnum type) {
        this.type = type;
    }

    @Generated
    public void setMatcher(MatcherTypeEnum matcher) {
        this.matcher = matcher;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Override
    @Generated
    public String toString() {
        return "Event(super=" + super.toString() + ", organizationId=" + this.getOrganizationId() + ", name=" + this.getName() + ", type=" + this.getType() + ", matcher=" + this.getMatcher() + ", url=" + this.getUrl() + ", selector=" + this.getSelector() + ")";
    }

    @Generated
    public static class EventBuilder {
        @Generated
        private Long organizationId;
        @Generated
        private String name;
        @Generated
        private EventTypeEnum type;
        @Generated
        private MatcherTypeEnum matcher;
        @Generated
        private String url;
        @Generated
        private String selector;

        @Generated
        EventBuilder() {
        }

        @Generated
        public EventBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public EventBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public EventBuilder type(EventTypeEnum type) {
            this.type = type;
            return this;
        }

        @Generated
        public EventBuilder matcher(MatcherTypeEnum matcher) {
            this.matcher = matcher;
            return this;
        }

        @Generated
        public EventBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public EventBuilder selector(String selector) {
            this.selector = selector;
            return this;
        }

        @Generated
        public Event build() {
            return new Event(this.organizationId, this.name, this.type, this.matcher, this.url, this.selector);
        }

        @Generated
        public String toString() {
            return "Event.EventBuilder(organizationId=" + this.organizationId + ", name=" + this.name + ", type=" + this.type + ", matcher=" + this.matcher + ", url=" + this.url + ", selector=" + this.selector + ")";
        }
    }
}

