/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="event_tracker")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")})
@Filter(name="tenantFilter", condition="organization_id = :organizationId")
public class EventTracker
extends AbstractAuditEntity
implements TenantSupport {
    @Column(name="organization_id")
    private Long organizationId;
    @Column(name="project_key")
    private String projectKey;
    @Column(name="environment_key")
    private String environmentKey;
    private String uuid;
    @Column(columnDefinition="BIGINT")
    private Long time;

    @Generated
    public static EventTrackerBuilder builder() {
        return new EventTrackerBuilder();
    }

    @Generated
    public EventTracker() {
    }

    @Generated
    public EventTracker(Long organizationId, String projectKey, String environmentKey, String uuid, Long time) {
        this.organizationId = organizationId;
        this.projectKey = projectKey;
        this.environmentKey = environmentKey;
        this.uuid = uuid;
        this.time = time;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Override
    @Generated
    public String toString() {
        return "EventTracker(super=" + super.toString() + ", organizationId=" + this.getOrganizationId() + ", projectKey=" + this.getProjectKey() + ", environmentKey=" + this.getEnvironmentKey() + ", uuid=" + this.getUuid() + ", time=" + this.getTime() + ")";
    }

    @Generated
    public static class EventTrackerBuilder {
        @Generated
        private Long organizationId;
        @Generated
        private String projectKey;
        @Generated
        private String environmentKey;
        @Generated
        private String uuid;
        @Generated
        private Long time;

        @Generated
        EventTrackerBuilder() {
        }

        @Generated
        public EventTrackerBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public EventTrackerBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public EventTrackerBuilder environmentKey(String environmentKey) {
            this.environmentKey = environmentKey;
            return this;
        }

        @Generated
        public EventTrackerBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        @Generated
        public EventTrackerBuilder time(Long time) {
            this.time = time;
            return this;
        }

        @Generated
        public EventTracker build() {
            return new EventTracker(this.organizationId, this.projectKey, this.environmentKey, this.uuid, this.time);
        }

        @Generated
        public String toString() {
            return "EventTracker.EventTrackerBuilder(organizationId=" + this.organizationId + ", projectKey=" + this.projectKey + ", environmentKey=" + this.environmentKey + ", uuid=" + this.uuid + ", time=" + this.time + ")";
        }
    }
}

