/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.MemberStatusEnum;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Organization;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.dao.listener.MemberEntityInterceptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="member")
@DynamicInsert
@FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")})
@Filter(name="deletedFilter", condition="deleted = :deleted")
@EntityListeners(value={MemberEntityInterceptor.class})
public class Member
extends AbstractAuditEntity {
    @Column(nullable=false, updatable=false)
    private String account;
    private String nickname;
    private String password;
    @Enumerated(value=EnumType.STRING)
    private MemberStatusEnum status;
    @Column(name="visited_time")
    private Date visitedTime;
    @Column(columnDefinition="TINYINT")
    private Boolean deleted;
    private String source;
    @OneToMany(mappedBy="member", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<OrganizationMember> organizationMembers = new ArrayList<OrganizationMember>();

    public Member(Long id, String account) {
        super.setId(id);
        this.account = account;
    }

    public List<Organization> getOrganizations() {
        return this.organizationMembers.stream().map(OrganizationMember::getOrganization).collect(Collectors.toList());
    }

    public void addOrganization(Organization organization, OrganizationRoleEnum role) {
        this.addOrganization(organization, role, true);
    }

    public void addOrganization(Organization organization, OrganizationRoleEnum role, boolean valid) {
        this.organizationMembers.add(new OrganizationMember(organization, this, role, valid, null));
    }

    public void deleteOrganization(Long organizationId) {
        OrganizationMember deleteOrganizationMember = null;
        for (OrganizationMember organizationMember : this.organizationMembers) {
            if (!organizationMember.getOrganization().getId().equals(organizationId)) continue;
            deleteOrganizationMember = organizationMember;
        }
        this.organizationMembers.remove(deleteOrganizationMember);
    }

    public OrganizationRoleEnum getRole(Long organizationId) {
        for (OrganizationMember organizationMember : this.organizationMembers) {
            if (!organizationMember.getOrganization().getId().equals(organizationId)) continue;
            return organizationMember.getRole();
        }
        return null;
    }

    @Generated
    public Member() {
    }

    @Generated
    public Member(String account, String nickname, String password, MemberStatusEnum status, Date visitedTime, Boolean deleted, String source, List<OrganizationMember> organizationMembers) {
        this.account = account;
        this.nickname = nickname;
        this.password = password;
        this.status = status;
        this.visitedTime = visitedTime;
        this.deleted = deleted;
        this.source = source;
        this.organizationMembers = organizationMembers;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public MemberStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public Date getVisitedTime() {
        return this.visitedTime;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public List<OrganizationMember> getOrganizationMembers() {
        return this.organizationMembers;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setStatus(MemberStatusEnum status) {
        this.status = status;
    }

    @Generated
    public void setVisitedTime(Date visitedTime) {
        this.visitedTime = visitedTime;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setOrganizationMembers(List<OrganizationMember> organizationMembers) {
        this.organizationMembers = organizationMembers;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Member)) {
            return false;
        }
        Member other = (Member)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        MemberStatusEnum this$status = this.getStatus();
        MemberStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$visitedTime = this.getVisitedTime();
        Date other$visitedTime = other.getVisitedTime();
        if (this$visitedTime == null ? other$visitedTime != null : !((Object)this$visitedTime).equals(other$visitedTime)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<OrganizationMember> this$organizationMembers = this.getOrganizationMembers();
        List<OrganizationMember> other$organizationMembers = other.getOrganizationMembers();
        return !(this$organizationMembers == null ? other$organizationMembers != null : !((Object)this$organizationMembers).equals(other$organizationMembers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Member;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        MemberStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $visitedTime = this.getVisitedTime();
        result = result * 59 + ($visitedTime == null ? 43 : ((Object)$visitedTime).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<OrganizationMember> $organizationMembers = this.getOrganizationMembers();
        result = result * 59 + ($organizationMembers == null ? 43 : ((Object)$organizationMembers).hashCode());
        return result;
    }
}

