/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.AlgorithmDenominatorEnum;
import io.featureprobe.api.base.enums.MetricTypeEnum;
import io.featureprobe.api.base.enums.WinCriteria;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Event;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="metric")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")})
@Filter(name="tenantFilter", condition="organization_id = :organizationId")
public class Metric
extends AbstractAuditEntity
implements TenantSupport {
    @Column(name="organization_id")
    private Long organizationId;
    private String name;
    @Column(columnDefinition="TEXT")
    private String description;
    private String unit;
    @Column(name="win_criteria")
    @Enumerated(value=EnumType.STRING)
    private WinCriteria winCriteria;
    @Enumerated(value=EnumType.STRING)
    private AlgorithmDenominatorEnum denominator;
    @Enumerated(value=EnumType.STRING)
    private MetricTypeEnum type;
    @Column(name="project_key")
    private String projectKey;
    @Column(name="environment_key")
    private String environmentKey;
    @Column(name="toggle_key")
    private String toggleKey;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="metric_event", joinColumns={@JoinColumn(name="metric_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="event_id", referencedColumnName="id")})
    private Set<Event> events;

    public Metric(MetricTypeEnum type, String projectKey, String environmentKey, String toggleKey, Set<Event> events) {
        this.type = type;
        this.projectKey = projectKey;
        this.environmentKey = environmentKey;
        this.toggleKey = toggleKey;
        this.events = events;
    }

    @Generated
    public static MetricBuilder builder() {
        return new MetricBuilder();
    }

    @Generated
    public Metric() {
    }

    @Generated
    public Metric(Long organizationId, String name, String description, String unit, WinCriteria winCriteria, AlgorithmDenominatorEnum denominator, MetricTypeEnum type, String projectKey, String environmentKey, String toggleKey, Set<Event> events) {
        this.organizationId = organizationId;
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.winCriteria = winCriteria;
        this.denominator = denominator;
        this.type = type;
        this.projectKey = projectKey;
        this.environmentKey = environmentKey;
        this.toggleKey = toggleKey;
        this.events = events;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public WinCriteria getWinCriteria() {
        return this.winCriteria;
    }

    @Generated
    public AlgorithmDenominatorEnum getDenominator() {
        return this.denominator;
    }

    @Generated
    public MetricTypeEnum getType() {
        return this.type;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Generated
    public String getToggleKey() {
        return this.toggleKey;
    }

    @Generated
    public Set<Event> getEvents() {
        return this.events;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Generated
    public void setWinCriteria(WinCriteria winCriteria) {
        this.winCriteria = winCriteria;
    }

    @Generated
    public void setDenominator(AlgorithmDenominatorEnum denominator) {
        this.denominator = denominator;
    }

    @Generated
    public void setType(MetricTypeEnum type) {
        this.type = type;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    @Generated
    public void setToggleKey(String toggleKey) {
        this.toggleKey = toggleKey;
    }

    @Generated
    public void setEvents(Set<Event> events) {
        this.events = events;
    }

    @Override
    @Generated
    public String toString() {
        return "Metric(super=" + super.toString() + ", organizationId=" + this.getOrganizationId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", unit=" + this.getUnit() + ", winCriteria=" + this.getWinCriteria() + ", denominator=" + this.getDenominator() + ", type=" + this.getType() + ", projectKey=" + this.getProjectKey() + ", environmentKey=" + this.getEnvironmentKey() + ", toggleKey=" + this.getToggleKey() + ", events=" + this.getEvents() + ")";
    }

    @Generated
    public static class MetricBuilder {
        @Generated
        private Long organizationId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String unit;
        @Generated
        private WinCriteria winCriteria;
        @Generated
        private AlgorithmDenominatorEnum denominator;
        @Generated
        private MetricTypeEnum type;
        @Generated
        private String projectKey;
        @Generated
        private String environmentKey;
        @Generated
        private String toggleKey;
        @Generated
        private Set<Event> events;

        @Generated
        MetricBuilder() {
        }

        @Generated
        public MetricBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public MetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MetricBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MetricBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Generated
        public MetricBuilder winCriteria(WinCriteria winCriteria) {
            this.winCriteria = winCriteria;
            return this;
        }

        @Generated
        public MetricBuilder denominator(AlgorithmDenominatorEnum denominator) {
            this.denominator = denominator;
            return this;
        }

        @Generated
        public MetricBuilder type(MetricTypeEnum type) {
            this.type = type;
            return this;
        }

        @Generated
        public MetricBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public MetricBuilder environmentKey(String environmentKey) {
            this.environmentKey = environmentKey;
            return this;
        }

        @Generated
        public MetricBuilder toggleKey(String toggleKey) {
            this.toggleKey = toggleKey;
            return this;
        }

        @Generated
        public MetricBuilder events(Set<Event> events) {
            this.events = events;
            return this;
        }

        @Generated
        public Metric build() {
            return new Metric(this.organizationId, this.name, this.description, this.unit, this.winCriteria, this.denominator, this.type, this.projectKey, this.environmentKey, this.toggleKey, this.events);
        }

        @Generated
        public String toString() {
            return "Metric.MetricBuilder(organizationId=" + this.organizationId + ", name=" + this.name + ", description=" + this.description + ", unit=" + this.unit + ", winCriteria=" + this.winCriteria + ", denominator=" + this.denominator + ", type=" + this.type + ", projectKey=" + this.projectKey + ", environmentKey=" + this.environmentKey + ", toggleKey=" + this.toggleKey + ", events=" + this.events + ")";
        }
    }
}

