/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="organization")
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
@DynamicInsert
@FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")})
@Filter(name="deletedFilter", condition="deleted = :deleted")
public class Organization
extends AbstractAuditEntity {
    private String name;
    @Column(columnDefinition="TINYINT")
    private boolean deleted;

    public Organization(String name) {
        this.name = name;
    }

    public static Organization createDefaultOrganization() {
        Organization organization = new Organization();
        organization.setName("Default Organization");
        return organization;
    }

    @Generated
    public Organization() {
    }

    @Generated
    public Organization(String name, boolean deleted) {
        this.name = name;
        this.deleted = deleted;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Organization)) {
            return false;
        }
        Organization other = (Organization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Organization;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

