/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.Organization;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;

@Entity
@Table(name="organization_member")
@DynamicInsert
public class OrganizationMember
extends AbstractAuditEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organization_id")
    Organization organization;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="member_id")
    private Member member;
    @Enumerated(value=EnumType.STRING)
    private OrganizationRoleEnum role;
    @Column(columnDefinition="TINYINT")
    private Boolean valid;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="login_time")
    private Date loginTime;

    @Generated
    public OrganizationMember() {
    }

    @Generated
    public OrganizationMember(Organization organization, Member member, OrganizationRoleEnum role, Boolean valid, Date loginTime) {
        this.organization = organization;
        this.member = member;
        this.role = role;
        this.valid = valid;
        this.loginTime = loginTime;
    }

    @Generated
    public Organization getOrganization() {
        return this.organization;
    }

    @Generated
    public Member getMember() {
        return this.member;
    }

    @Generated
    public OrganizationRoleEnum getRole() {
        return this.role;
    }

    @Generated
    public Boolean getValid() {
        return this.valid;
    }

    @Generated
    public Date getLoginTime() {
        return this.loginTime;
    }

    @Generated
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    @Generated
    public void setMember(Member member) {
        this.member = member;
    }

    @Generated
    public void setRole(OrganizationRoleEnum role) {
        this.role = role;
    }

    @Generated
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    @Generated
    public void setLoginTime(Date loginTime) {
        this.loginTime = loginTime;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrganizationMember)) {
            return false;
        }
        OrganizationMember other = (OrganizationMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        Organization this$organization = this.getOrganization();
        Organization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
            return false;
        }
        Member this$member = this.getMember();
        Member other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        OrganizationRoleEnum this$role = this.getRole();
        OrganizationRoleEnum other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        Date this$loginTime = this.getLoginTime();
        Date other$loginTime = other.getLoginTime();
        return !(this$loginTime == null ? other$loginTime != null : !((Object)this$loginTime).equals(other$loginTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OrganizationMember;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        Organization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
        Member $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        OrganizationRoleEnum $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        Date $loginTime = this.getLoginTime();
        result = result * 59 + ($loginTime == null ? 43 : ((Object)$loginTime).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "OrganizationMember(organization=" + this.getOrganization() + ", member=" + this.getMember() + ", role=" + this.getRole() + ", valid=" + this.getValid() + ", loginTime=" + this.getLoginTime() + ")";
    }
}

