/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Where;

@Entity
@Table(name="project")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDefs(value={@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")}), @FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")}), @FilterDef(name="archivedFilter", parameters={@ParamDef(name="archived", type="boolean")})})
@Filters(value={@Filter(name="tenantFilter", condition="organization_id = :organizationId"), @Filter(name="deletedFilter", condition="deleted = :deleted"), @Filter(name="archivedFilter", condition="archived = :archived")})
public class Project
extends AbstractAuditEntity
implements TenantSupport,
Serializable {
    @Column(name="[key]")
    private String key;
    private String name;
    private String description;
    @Column(columnDefinition="TINYINT")
    private boolean deleted;
    @Column(columnDefinition="TINYINT")
    private boolean archived;
    @Column(name="organization_id")
    private Long organizationId;
    @OneToMany(mappedBy="project", cascade={CascadeType.PERSIST})
    @Where(clause="archived = false")
    @OrderBy(clause="created_time asc")
    private List<Environment> environments;

    @Generated
    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.isArchived() != other.isArchived()) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        result = result * 59 + (this.isArchived() ? 79 : 97);
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public Project() {
    }

    @Generated
    public Project(String key, String name, String description, boolean deleted, boolean archived, Long organizationId, List<Environment> environments) {
        this.key = key;
        this.name = name;
        this.description = description;
        this.deleted = deleted;
        this.archived = archived;
        this.organizationId = organizationId;
        this.environments = environments;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public boolean isArchived() {
        return this.archived;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public List<Environment> getEnvironments() {
        return this.environments;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setEnvironments(List<Environment> environments) {
        this.environments = environments;
    }

    @Override
    @Generated
    public String toString() {
        return "Project(super=" + super.toString() + ", key=" + this.getKey() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", deleted=" + this.isDeleted() + ", archived=" + this.isArchived() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @Generated
    public static class ProjectBuilder {
        @Generated
        private String key;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private boolean deleted;
        @Generated
        private boolean archived;
        @Generated
        private Long organizationId;
        @Generated
        private List<Environment> environments;

        @Generated
        ProjectBuilder() {
        }

        @Generated
        public ProjectBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public ProjectBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ProjectBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ProjectBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public ProjectBuilder archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        @Generated
        public ProjectBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public ProjectBuilder environments(List<Environment> environments) {
            this.environments = environments;
            return this;
        }

        @Generated
        public Project build() {
            return new Project(this.key, this.name, this.description, this.deleted, this.archived, this.organizationId, this.environments);
        }

        @Generated
        public String toString() {
            return "Project.ProjectBuilder(key=" + this.key + ", name=" + this.name + ", description=" + this.description + ", deleted=" + this.deleted + ", archived=" + this.archived + ", organizationId=" + this.organizationId + ", environments=" + this.environments + ")";
        }
    }
}

