/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="segment")
@DynamicInsert
@DynamicUpdate
@EntityListeners(value={TenantEntityListener.class})
@FilterDefs(value={@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")}), @FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")})})
@Filters(value={@Filter(name="tenantFilter", condition="organization_id = :organizationId"), @Filter(name="deletedFilter", condition="deleted = :deleted")})
public class Segment
extends AbstractAuditEntity
implements TenantSupport {
    private String name;
    @Column(name="[key]")
    private String key;
    @Column(name="unique_Key")
    private String uniqueKey;
    private String description;
    @Column(name="project_key")
    private String projectKey;
    @Version
    private Long version;
    @Column(columnDefinition="LONGTEXT")
    private String rules;
    @Column(columnDefinition="TINYINT")
    private boolean deleted;
    @Column(name="organization_id")
    private Long organizationId;

    public String uniqueKey() {
        return this.projectKey + "&" + this.key;
    }

    @Generated
    public static SegmentBuilder builder() {
        return new SegmentBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$uniqueKey = this.getUniqueKey();
        String other$uniqueKey = other.getUniqueKey();
        if (this$uniqueKey == null ? other$uniqueKey != null : !this$uniqueKey.equals(other$uniqueKey)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
            return false;
        }
        String this$rules = this.getRules();
        String other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !this$rules.equals(other$rules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Segment;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $uniqueKey = this.getUniqueKey();
        result = result * 59 + ($uniqueKey == null ? 43 : $uniqueKey.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        String $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : $rules.hashCode());
        return result;
    }

    @Generated
    public Segment() {
    }

    @Generated
    public Segment(String name, String key, String uniqueKey, String description, String projectKey, Long version, String rules, boolean deleted, Long organizationId) {
        this.name = name;
        this.key = key;
        this.uniqueKey = uniqueKey;
        this.description = description;
        this.projectKey = projectKey;
        this.version = version;
        this.rules = rules;
        this.deleted = deleted;
        this.organizationId = organizationId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getUniqueKey() {
        return this.uniqueKey;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public String getRules() {
        return this.rules;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setRules(String rules) {
        this.rules = rules;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Override
    @Generated
    public String toString() {
        return "Segment(super=" + super.toString() + ", name=" + this.getName() + ", key=" + this.getKey() + ", uniqueKey=" + this.getUniqueKey() + ", description=" + this.getDescription() + ", projectKey=" + this.getProjectKey() + ", version=" + this.getVersion() + ", rules=" + this.getRules() + ", deleted=" + this.isDeleted() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @Generated
    public static class SegmentBuilder {
        @Generated
        private String name;
        @Generated
        private String key;
        @Generated
        private String uniqueKey;
        @Generated
        private String description;
        @Generated
        private String projectKey;
        @Generated
        private Long version;
        @Generated
        private String rules;
        @Generated
        private boolean deleted;
        @Generated
        private Long organizationId;

        @Generated
        SegmentBuilder() {
        }

        @Generated
        public SegmentBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SegmentBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public SegmentBuilder uniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
            return this;
        }

        @Generated
        public SegmentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public SegmentBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public SegmentBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public SegmentBuilder rules(String rules) {
            this.rules = rules;
            return this;
        }

        @Generated
        public SegmentBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public SegmentBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public Segment build() {
            return new Segment(this.name, this.key, this.uniqueKey, this.description, this.projectKey, this.version, this.rules, this.deleted, this.organizationId);
        }

        @Generated
        public String toString() {
            return "Segment.SegmentBuilder(name=" + this.name + ", key=" + this.key + ", uniqueKey=" + this.uniqueKey + ", description=" + this.description + ", projectKey=" + this.projectKey + ", version=" + this.version + ", rules=" + this.rules + ", deleted=" + this.deleted + ", organizationId=" + this.organizationId + ")";
        }
    }
}

