/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ParamDef;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
@Entity
@Table(name="tag")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDefs(value={@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")}), @FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")})})
@Filters(value={@Filter(name="tenantFilter", condition="organization_id = :organizationId"), @Filter(name="deletedFilter", condition="deleted = :deleted")})
public class Tag
extends AbstractAuditEntity
implements TenantSupport {
    private String name;
    @Column(name="project_key")
    private String projectKey;
    @Column(columnDefinition="TINYINT")
    private boolean deleted;
    @Column(name="organization_id")
    private Long organizationId;

    @Generated
    public static TagBuilder builder() {
        return new TagBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        return !(this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        return result;
    }

    @Generated
    public Tag() {
    }

    @Generated
    public Tag(String name, String projectKey, boolean deleted, Long organizationId) {
        this.name = name;
        this.projectKey = projectKey;
        this.deleted = deleted;
        this.organizationId = organizationId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Override
    @Generated
    public String toString() {
        return "Tag(super=" + super.toString() + ", name=" + this.getName() + ", projectKey=" + this.getProjectKey() + ", deleted=" + this.isDeleted() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @Generated
    public static class TagBuilder {
        @Generated
        private String name;
        @Generated
        private String projectKey;
        @Generated
        private boolean deleted;
        @Generated
        private Long organizationId;

        @Generated
        TagBuilder() {
        }

        @Generated
        public TagBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public TagBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public TagBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public TagBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public Tag build() {
            return new Tag(this.name, this.projectKey, this.deleted, this.organizationId);
        }

        @Generated
        public String toString() {
            return "Tag.TagBuilder(name=" + this.name + ", projectKey=" + this.projectKey + ", deleted=" + this.deleted + ", organizationId=" + this.organizationId + ")";
        }
    }
}

