/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.ToggleReleaseStatusEnum;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="targeting")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDefs(value={@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")}), @FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")})})
@Filters(value={@Filter(name="tenantFilter", condition="organization_id = :organizationId"), @Filter(name="deletedFilter", condition="deleted = :deleted")})
public class Targeting
extends AbstractAuditEntity
implements TenantSupport {
    @Column(name="toggle_key")
    private String toggleKey;
    @Column(name="environment_key")
    private String environmentKey;
    @Column(name="project_key")
    private String projectKey;
    private Long version;
    @Column(columnDefinition="BIT", length=1)
    private boolean disabled;
    @Column(columnDefinition="LONGTEXT")
    private String content;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="publish_time")
    private Date publishTime;
    @Column(columnDefinition="BIT", length=1)
    private boolean deleted;
    @Column(name="organization_id")
    private Long organizationId;
    @Enumerated(value=EnumType.STRING)
    private ToggleReleaseStatusEnum status;
    @Version
    @Column(name="_lock_version")
    private Long lockVersion;

    public String uniqueKey() {
        return this.projectKey + "&" + this.environmentKey + "&" + this.toggleKey;
    }

    @Generated
    public static TargetingBuilder builder() {
        return new TargetingBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Targeting)) {
            return false;
        }
        Targeting other = (Targeting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        Long this$lockVersion = this.getLockVersion();
        Long other$lockVersion = other.getLockVersion();
        if (this$lockVersion == null ? other$lockVersion != null : !((Object)this$lockVersion).equals(other$lockVersion)) {
            return false;
        }
        String this$toggleKey = this.getToggleKey();
        String other$toggleKey = other.getToggleKey();
        if (this$toggleKey == null ? other$toggleKey != null : !this$toggleKey.equals(other$toggleKey)) {
            return false;
        }
        String this$environmentKey = this.getEnvironmentKey();
        String other$environmentKey = other.getEnvironmentKey();
        if (this$environmentKey == null ? other$environmentKey != null : !this$environmentKey.equals(other$environmentKey)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Date this$publishTime = this.getPublishTime();
        Date other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        ToggleReleaseStatusEnum this$status = this.getStatus();
        ToggleReleaseStatusEnum other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Targeting;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        Long $lockVersion = this.getLockVersion();
        result = result * 59 + ($lockVersion == null ? 43 : ((Object)$lockVersion).hashCode());
        String $toggleKey = this.getToggleKey();
        result = result * 59 + ($toggleKey == null ? 43 : $toggleKey.hashCode());
        String $environmentKey = this.getEnvironmentKey();
        result = result * 59 + ($environmentKey == null ? 43 : $environmentKey.hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Date $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        ToggleReleaseStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Generated
    public Targeting() {
    }

    @Generated
    public Targeting(String toggleKey, String environmentKey, String projectKey, Long version, boolean disabled, String content, Date publishTime, boolean deleted, Long organizationId, ToggleReleaseStatusEnum status, Long lockVersion) {
        this.toggleKey = toggleKey;
        this.environmentKey = environmentKey;
        this.projectKey = projectKey;
        this.version = version;
        this.disabled = disabled;
        this.content = content;
        this.publishTime = publishTime;
        this.deleted = deleted;
        this.organizationId = organizationId;
        this.status = status;
        this.lockVersion = lockVersion;
    }

    @Generated
    public String getToggleKey() {
        return this.toggleKey;
    }

    @Generated
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Date getPublishTime() {
        return this.publishTime;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public ToggleReleaseStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public Long getLockVersion() {
        return this.lockVersion;
    }

    @Generated
    public void setToggleKey(String toggleKey) {
        this.toggleKey = toggleKey;
    }

    @Generated
    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setStatus(ToggleReleaseStatusEnum status) {
        this.status = status;
    }

    @Generated
    public void setLockVersion(Long lockVersion) {
        this.lockVersion = lockVersion;
    }

    @Override
    @Generated
    public String toString() {
        return "Targeting(super=" + super.toString() + ", toggleKey=" + this.getToggleKey() + ", environmentKey=" + this.getEnvironmentKey() + ", projectKey=" + this.getProjectKey() + ", version=" + this.getVersion() + ", disabled=" + this.isDisabled() + ", content=" + this.getContent() + ", publishTime=" + this.getPublishTime() + ", deleted=" + this.isDeleted() + ", organizationId=" + this.getOrganizationId() + ", status=" + this.getStatus() + ", lockVersion=" + this.getLockVersion() + ")";
    }

    @Generated
    public static class TargetingBuilder {
        @Generated
        private String toggleKey;
        @Generated
        private String environmentKey;
        @Generated
        private String projectKey;
        @Generated
        private Long version;
        @Generated
        private boolean disabled;
        @Generated
        private String content;
        @Generated
        private Date publishTime;
        @Generated
        private boolean deleted;
        @Generated
        private Long organizationId;
        @Generated
        private ToggleReleaseStatusEnum status;
        @Generated
        private Long lockVersion;

        @Generated
        TargetingBuilder() {
        }

        @Generated
        public TargetingBuilder toggleKey(String toggleKey) {
            this.toggleKey = toggleKey;
            return this;
        }

        @Generated
        public TargetingBuilder environmentKey(String environmentKey) {
            this.environmentKey = environmentKey;
            return this;
        }

        @Generated
        public TargetingBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public TargetingBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public TargetingBuilder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Generated
        public TargetingBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public TargetingBuilder publishTime(Date publishTime) {
            this.publishTime = publishTime;
            return this;
        }

        @Generated
        public TargetingBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public TargetingBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public TargetingBuilder status(ToggleReleaseStatusEnum status) {
            this.status = status;
            return this;
        }

        @Generated
        public TargetingBuilder lockVersion(Long lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        @Generated
        public Targeting build() {
            return new Targeting(this.toggleKey, this.environmentKey, this.projectKey, this.version, this.disabled, this.content, this.publishTime, this.deleted, this.organizationId, this.status, this.lockVersion);
        }

        @Generated
        public String toString() {
            return "Targeting.TargetingBuilder(toggleKey=" + this.toggleKey + ", environmentKey=" + this.environmentKey + ", projectKey=" + this.projectKey + ", version=" + this.version + ", disabled=" + this.disabled + ", content=" + this.content + ", publishTime=" + this.publishTime + ", deleted=" + this.deleted + ", organizationId=" + this.organizationId + ", status=" + this.status + ", lockVersion=" + this.lockVersion + ")";
        }
    }
}

