/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.base.enums.SketchStatusEnum;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="targeting_sketch")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")})
@Filter(name="tenantFilter", condition="organization_id = :organizationId")
public class TargetingSketch
extends AbstractAuditEntity
implements TenantSupport,
Serializable {
    @Column(name="approval_id")
    private Long approvalId;
    @Column(name="organization_id")
    private Long organizationId;
    @Column(name="project_key")
    private String projectKey;
    @Column(name="environment_key")
    private String environmentKey;
    @Column(name="toggle_key")
    private String toggleKey;
    @Column(name="old_version")
    private Long oldVersion;
    @Column(columnDefinition="LONGTEXT")
    private String content;
    private String comment;
    @Column(columnDefinition="TINYINT")
    private Boolean disabled;
    @Enumerated(value=EnumType.STRING)
    private SketchStatusEnum status;

    public String uniqueKey() {
        return this.projectKey + "&" + this.environmentKey + "&" + this.toggleKey;
    }

    @Generated
    public static TargetingSketchBuilder builder() {
        return new TargetingSketchBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetingSketch)) {
            return false;
        }
        TargetingSketch other = (TargetingSketch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$approvalId = this.getApprovalId();
        Long other$approvalId = other.getApprovalId();
        if (this$approvalId == null ? other$approvalId != null : !((Object)this$approvalId).equals(other$approvalId)) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        Long this$oldVersion = this.getOldVersion();
        Long other$oldVersion = other.getOldVersion();
        if (this$oldVersion == null ? other$oldVersion != null : !((Object)this$oldVersion).equals(other$oldVersion)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
            return false;
        }
        String this$environmentKey = this.getEnvironmentKey();
        String other$environmentKey = other.getEnvironmentKey();
        if (this$environmentKey == null ? other$environmentKey != null : !this$environmentKey.equals(other$environmentKey)) {
            return false;
        }
        String this$toggleKey = this.getToggleKey();
        String other$toggleKey = other.getToggleKey();
        if (this$toggleKey == null ? other$toggleKey != null : !this$toggleKey.equals(other$toggleKey)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        SketchStatusEnum this$status = this.getStatus();
        SketchStatusEnum other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TargetingSketch;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $approvalId = this.getApprovalId();
        result = result * 59 + ($approvalId == null ? 43 : ((Object)$approvalId).hashCode());
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        Long $oldVersion = this.getOldVersion();
        result = result * 59 + ($oldVersion == null ? 43 : ((Object)$oldVersion).hashCode());
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        String $environmentKey = this.getEnvironmentKey();
        result = result * 59 + ($environmentKey == null ? 43 : $environmentKey.hashCode());
        String $toggleKey = this.getToggleKey();
        result = result * 59 + ($toggleKey == null ? 43 : $toggleKey.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        SketchStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Generated
    public TargetingSketch() {
    }

    @Generated
    public TargetingSketch(Long approvalId, Long organizationId, String projectKey, String environmentKey, String toggleKey, Long oldVersion, String content, String comment, Boolean disabled, SketchStatusEnum status) {
        this.approvalId = approvalId;
        this.organizationId = organizationId;
        this.projectKey = projectKey;
        this.environmentKey = environmentKey;
        this.toggleKey = toggleKey;
        this.oldVersion = oldVersion;
        this.content = content;
        this.comment = comment;
        this.disabled = disabled;
        this.status = status;
    }

    @Generated
    public Long getApprovalId() {
        return this.approvalId;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Generated
    public String getToggleKey() {
        return this.toggleKey;
    }

    @Generated
    public Long getOldVersion() {
        return this.oldVersion;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public SketchStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public void setApprovalId(Long approvalId) {
        this.approvalId = approvalId;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    @Generated
    public void setToggleKey(String toggleKey) {
        this.toggleKey = toggleKey;
    }

    @Generated
    public void setOldVersion(Long oldVersion) {
        this.oldVersion = oldVersion;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public void setStatus(SketchStatusEnum status) {
        this.status = status;
    }

    @Override
    @Generated
    public String toString() {
        return "TargetingSketch(super=" + super.toString() + ", approvalId=" + this.getApprovalId() + ", organizationId=" + this.getOrganizationId() + ", projectKey=" + this.getProjectKey() + ", environmentKey=" + this.getEnvironmentKey() + ", toggleKey=" + this.getToggleKey() + ", oldVersion=" + this.getOldVersion() + ", content=" + this.getContent() + ", comment=" + this.getComment() + ", disabled=" + this.getDisabled() + ", status=" + this.getStatus() + ")";
    }

    @Generated
    public static class TargetingSketchBuilder {
        @Generated
        private Long approvalId;
        @Generated
        private Long organizationId;
        @Generated
        private String projectKey;
        @Generated
        private String environmentKey;
        @Generated
        private String toggleKey;
        @Generated
        private Long oldVersion;
        @Generated
        private String content;
        @Generated
        private String comment;
        @Generated
        private Boolean disabled;
        @Generated
        private SketchStatusEnum status;

        @Generated
        TargetingSketchBuilder() {
        }

        @Generated
        public TargetingSketchBuilder approvalId(Long approvalId) {
            this.approvalId = approvalId;
            return this;
        }

        @Generated
        public TargetingSketchBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public TargetingSketchBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public TargetingSketchBuilder environmentKey(String environmentKey) {
            this.environmentKey = environmentKey;
            return this;
        }

        @Generated
        public TargetingSketchBuilder toggleKey(String toggleKey) {
            this.toggleKey = toggleKey;
            return this;
        }

        @Generated
        public TargetingSketchBuilder oldVersion(Long oldVersion) {
            this.oldVersion = oldVersion;
            return this;
        }

        @Generated
        public TargetingSketchBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public TargetingSketchBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public TargetingSketchBuilder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Generated
        public TargetingSketchBuilder status(SketchStatusEnum status) {
            this.status = status;
            return this;
        }

        @Generated
        public TargetingSketch build() {
            return new TargetingSketch(this.approvalId, this.organizationId, this.projectKey, this.environmentKey, this.toggleKey, this.oldVersion, this.content, this.comment, this.disabled, this.status);
        }

        @Generated
        public String toString() {
            return "TargetingSketch.TargetingSketchBuilder(approvalId=" + this.approvalId + ", organizationId=" + this.organizationId + ", projectKey=" + this.projectKey + ", environmentKey=" + this.environmentKey + ", toggleKey=" + this.toggleKey + ", oldVersion=" + this.oldVersion + ", content=" + this.content + ", comment=" + this.comment + ", disabled=" + this.disabled + ", status=" + this.status + ")";
        }
    }
}

