/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="targeting_version")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")})
@Filter(name="tenantFilter", condition="organization_id = :organizationId")
public class TargetingVersion
extends AbstractAuditEntity
implements TenantSupport {
    @Column(name="project_key")
    private String projectKey;
    @Column(name="environment_key")
    private String environmentKey;
    @Column(name="toggle_key")
    private String toggleKey;
    private String comment;
    @Column(columnDefinition="LONGTEXT")
    private String content;
    @Column(columnDefinition="TINYINT")
    private Boolean disabled;
    @Column(name="organization_id")
    private Long organizationId;
    private Long version;
    @Column(name="approval_id")
    private Long approvalId;

    @Generated
    public static TargetingVersionBuilder builder() {
        return new TargetingVersionBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetingVersion)) {
            return false;
        }
        TargetingVersion other = (TargetingVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$approvalId = this.getApprovalId();
        Long other$approvalId = other.getApprovalId();
        if (this$approvalId == null ? other$approvalId != null : !((Object)this$approvalId).equals(other$approvalId)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
            return false;
        }
        String this$environmentKey = this.getEnvironmentKey();
        String other$environmentKey = other.getEnvironmentKey();
        if (this$environmentKey == null ? other$environmentKey != null : !this$environmentKey.equals(other$environmentKey)) {
            return false;
        }
        String this$toggleKey = this.getToggleKey();
        String other$toggleKey = other.getToggleKey();
        if (this$toggleKey == null ? other$toggleKey != null : !this$toggleKey.equals(other$toggleKey)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TargetingVersion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $approvalId = this.getApprovalId();
        result = result * 59 + ($approvalId == null ? 43 : ((Object)$approvalId).hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        String $environmentKey = this.getEnvironmentKey();
        result = result * 59 + ($environmentKey == null ? 43 : $environmentKey.hashCode());
        String $toggleKey = this.getToggleKey();
        result = result * 59 + ($toggleKey == null ? 43 : $toggleKey.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    @Generated
    public TargetingVersion() {
    }

    @Generated
    public TargetingVersion(String projectKey, String environmentKey, String toggleKey, String comment, String content, Boolean disabled, Long organizationId, Long version, Long approvalId) {
        this.projectKey = projectKey;
        this.environmentKey = environmentKey;
        this.toggleKey = toggleKey;
        this.comment = comment;
        this.content = content;
        this.disabled = disabled;
        this.organizationId = organizationId;
        this.version = version;
        this.approvalId = approvalId;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Generated
    public String getToggleKey() {
        return this.toggleKey;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public Long getApprovalId() {
        return this.approvalId;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    @Generated
    public void setToggleKey(String toggleKey) {
        this.toggleKey = toggleKey;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setApprovalId(Long approvalId) {
        this.approvalId = approvalId;
    }

    @Override
    @Generated
    public String toString() {
        return "TargetingVersion(super=" + super.toString() + ", projectKey=" + this.getProjectKey() + ", environmentKey=" + this.getEnvironmentKey() + ", toggleKey=" + this.getToggleKey() + ", comment=" + this.getComment() + ", content=" + this.getContent() + ", disabled=" + this.getDisabled() + ", organizationId=" + this.getOrganizationId() + ", version=" + this.getVersion() + ", approvalId=" + this.getApprovalId() + ")";
    }

    @Generated
    public static class TargetingVersionBuilder {
        @Generated
        private String projectKey;
        @Generated
        private String environmentKey;
        @Generated
        private String toggleKey;
        @Generated
        private String comment;
        @Generated
        private String content;
        @Generated
        private Boolean disabled;
        @Generated
        private Long organizationId;
        @Generated
        private Long version;
        @Generated
        private Long approvalId;

        @Generated
        TargetingVersionBuilder() {
        }

        @Generated
        public TargetingVersionBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public TargetingVersionBuilder environmentKey(String environmentKey) {
            this.environmentKey = environmentKey;
            return this;
        }

        @Generated
        public TargetingVersionBuilder toggleKey(String toggleKey) {
            this.toggleKey = toggleKey;
            return this;
        }

        @Generated
        public TargetingVersionBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public TargetingVersionBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public TargetingVersionBuilder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Generated
        public TargetingVersionBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public TargetingVersionBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public TargetingVersionBuilder approvalId(Long approvalId) {
            this.approvalId = approvalId;
            return this;
        }

        @Generated
        public TargetingVersion build() {
            return new TargetingVersion(this.projectKey, this.environmentKey, this.toggleKey, this.comment, this.content, this.disabled, this.organizationId, this.version, this.approvalId);
        }

        @Generated
        public String toString() {
            return "TargetingVersion.TargetingVersionBuilder(projectKey=" + this.projectKey + ", environmentKey=" + this.environmentKey + ", toggleKey=" + this.toggleKey + ", comment=" + this.comment + ", content=" + this.content + ", disabled=" + this.disabled + ", organizationId=" + this.organizationId + ", version=" + this.version + ", approvalId=" + this.approvalId + ")";
        }
    }
}

