/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Tag;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ParamDef;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
@Entity
@Table(name="toggle")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDefs(value={@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")}), @FilterDef(name="deletedFilter", parameters={@ParamDef(name="deleted", type="boolean")}), @FilterDef(name="archivedFilter", parameters={@ParamDef(name="archived", type="boolean")})})
@Filters(value={@Filter(name="tenantFilter", condition="organization_id = :organizationId"), @Filter(name="deletedFilter", condition="deleted = :deleted"), @Filter(name="archivedFilter", condition="archived = :archived")})
public class Toggle
extends AbstractAuditEntity
implements TenantSupport {
    private String name;
    @Column(name="[key]")
    private String key;
    @Column(columnDefinition="BIT", length=1)
    private boolean permanent;
    @Column(name="description", columnDefinition="TEXT")
    private String desc;
    @Column(name="return_type", columnDefinition="CHAR")
    private String returnType;
    @Column(name="disabled_serve")
    private Integer disabledServe;
    @Column(columnDefinition="TEXT")
    private String variations;
    @Column(name="project_key")
    private String projectKey;
    @Column(name="client_availability", columnDefinition="BIT", length=1)
    private Boolean clientAvailability;
    @Column(columnDefinition="BIT", length=1)
    private boolean archived;
    @Column(columnDefinition="BIT", length=1)
    private boolean deleted;
    @Column(name="organization_id")
    private Long organizationId;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="toggle_tag", joinColumns={@JoinColumn(name="toggle_key", referencedColumnName="key")}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id"), @JoinColumn(name="organization_id", referencedColumnName="organization_id")})
    private Set<Tag> tags = new HashSet<Tag>();

    public String uniqueKey() {
        return this.projectKey + "&" + this.key;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Toggle)) {
            return false;
        }
        Toggle other = (Toggle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPermanent() != other.isPermanent()) {
            return false;
        }
        if (this.isArchived() != other.isArchived()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Integer this$disabledServe = this.getDisabledServe();
        Integer other$disabledServe = other.getDisabledServe();
        if (this$disabledServe == null ? other$disabledServe != null : !((Object)this$disabledServe).equals(other$disabledServe)) {
            return false;
        }
        Boolean this$clientAvailability = this.getClientAvailability();
        Boolean other$clientAvailability = other.getClientAvailability();
        if (this$clientAvailability == null ? other$clientAvailability != null : !((Object)this$clientAvailability).equals(other$clientAvailability)) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        String this$variations = this.getVariations();
        String other$variations = other.getVariations();
        if (this$variations == null ? other$variations != null : !this$variations.equals(other$variations)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
            return false;
        }
        Set<Tag> this$tags = this.getTags();
        Set<Tag> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Toggle;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPermanent() ? 79 : 97);
        result = result * 59 + (this.isArchived() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Integer $disabledServe = this.getDisabledServe();
        result = result * 59 + ($disabledServe == null ? 43 : ((Object)$disabledServe).hashCode());
        Boolean $clientAvailability = this.getClientAvailability();
        result = result * 59 + ($clientAvailability == null ? 43 : ((Object)$clientAvailability).hashCode());
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        String $variations = this.getVariations();
        result = result * 59 + ($variations == null ? 43 : $variations.hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        Set<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public boolean isPermanent() {
        return this.permanent;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public String getReturnType() {
        return this.returnType;
    }

    @Generated
    public Integer getDisabledServe() {
        return this.disabledServe;
    }

    @Generated
    public String getVariations() {
        return this.variations;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public Boolean getClientAvailability() {
        return this.clientAvailability;
    }

    @Generated
    public boolean isArchived() {
        return this.archived;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public Set<Tag> getTags() {
        return this.tags;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    @Generated
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Generated
    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Generated
    public void setDisabledServe(Integer disabledServe) {
        this.disabledServe = disabledServe;
    }

    @Generated
    public void setVariations(String variations) {
        this.variations = variations;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setClientAvailability(Boolean clientAvailability) {
        this.clientAvailability = clientAvailability;
    }

    @Generated
    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }
}

