/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dao.entity;

import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.TenantSupport;
import io.featureprobe.api.dao.listener.TenantEntityListener;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="toggle_control_conf")
@DynamicInsert
@EntityListeners(value={TenantEntityListener.class})
@FilterDef(name="tenantFilter", parameters={@ParamDef(name="organizationId", type="long")})
@Filter(name="tenantFilter", condition="organization_id = :organizationId")
public class ToggleControlConf
extends AbstractAuditEntity
implements TenantSupport {
    @Column(name="toggle_key")
    private String toggleKey;
    @Column(name="environment_key")
    private String environmentKey;
    @Column(name="project_key")
    private String projectKey;
    @Column(name="track_access_events", columnDefinition="BIT", length=1)
    private boolean trackAccessEvents;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="track_start_time")
    private Date trackStartTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="track_end_time")
    private Date trackEndTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_modified")
    private Date lastModified;
    @Column(name="organization_id")
    private Long organizationId;

    public String uniqueKey() {
        return this.projectKey + "&" + this.environmentKey + "&" + this.toggleKey;
    }

    @Generated
    public static ToggleControlConfBuilder builder() {
        return new ToggleControlConfBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToggleControlConf)) {
            return false;
        }
        ToggleControlConf other = (ToggleControlConf)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isTrackAccessEvents() != other.isTrackAccessEvents()) {
            return false;
        }
        Long this$organizationId = this.getOrganizationId();
        Long other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        String this$toggleKey = this.getToggleKey();
        String other$toggleKey = other.getToggleKey();
        if (this$toggleKey == null ? other$toggleKey != null : !this$toggleKey.equals(other$toggleKey)) {
            return false;
        }
        String this$environmentKey = this.getEnvironmentKey();
        String other$environmentKey = other.getEnvironmentKey();
        if (this$environmentKey == null ? other$environmentKey != null : !this$environmentKey.equals(other$environmentKey)) {
            return false;
        }
        String this$projectKey = this.getProjectKey();
        String other$projectKey = other.getProjectKey();
        if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
            return false;
        }
        Date this$trackStartTime = this.getTrackStartTime();
        Date other$trackStartTime = other.getTrackStartTime();
        if (this$trackStartTime == null ? other$trackStartTime != null : !((Object)this$trackStartTime).equals(other$trackStartTime)) {
            return false;
        }
        Date this$trackEndTime = this.getTrackEndTime();
        Date other$trackEndTime = other.getTrackEndTime();
        if (this$trackEndTime == null ? other$trackEndTime != null : !((Object)this$trackEndTime).equals(other$trackEndTime)) {
            return false;
        }
        Date this$lastModified = this.getLastModified();
        Date other$lastModified = other.getLastModified();
        return !(this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ToggleControlConf;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isTrackAccessEvents() ? 79 : 97);
        Long $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        String $toggleKey = this.getToggleKey();
        result = result * 59 + ($toggleKey == null ? 43 : $toggleKey.hashCode());
        String $environmentKey = this.getEnvironmentKey();
        result = result * 59 + ($environmentKey == null ? 43 : $environmentKey.hashCode());
        String $projectKey = this.getProjectKey();
        result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
        Date $trackStartTime = this.getTrackStartTime();
        result = result * 59 + ($trackStartTime == null ? 43 : ((Object)$trackStartTime).hashCode());
        Date $trackEndTime = this.getTrackEndTime();
        result = result * 59 + ($trackEndTime == null ? 43 : ((Object)$trackEndTime).hashCode());
        Date $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        return result;
    }

    @Generated
    public ToggleControlConf() {
    }

    @Generated
    public ToggleControlConf(String toggleKey, String environmentKey, String projectKey, boolean trackAccessEvents, Date trackStartTime, Date trackEndTime, Date lastModified, Long organizationId) {
        this.toggleKey = toggleKey;
        this.environmentKey = environmentKey;
        this.projectKey = projectKey;
        this.trackAccessEvents = trackAccessEvents;
        this.trackStartTime = trackStartTime;
        this.trackEndTime = trackEndTime;
        this.lastModified = lastModified;
        this.organizationId = organizationId;
    }

    @Generated
    public String getToggleKey() {
        return this.toggleKey;
    }

    @Generated
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Generated
    public String getProjectKey() {
        return this.projectKey;
    }

    @Generated
    public boolean isTrackAccessEvents() {
        return this.trackAccessEvents;
    }

    @Generated
    public Date getTrackStartTime() {
        return this.trackStartTime;
    }

    @Generated
    public Date getTrackEndTime() {
        return this.trackEndTime;
    }

    @Generated
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    @Generated
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public void setToggleKey(String toggleKey) {
        this.toggleKey = toggleKey;
    }

    @Generated
    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    @Generated
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Generated
    public void setTrackAccessEvents(boolean trackAccessEvents) {
        this.trackAccessEvents = trackAccessEvents;
    }

    @Generated
    public void setTrackStartTime(Date trackStartTime) {
        this.trackStartTime = trackStartTime;
    }

    @Generated
    public void setTrackEndTime(Date trackEndTime) {
        this.trackEndTime = trackEndTime;
    }

    @Generated
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    @Generated
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @Override
    @Generated
    public String toString() {
        return "ToggleControlConf(super=" + super.toString() + ", toggleKey=" + this.getToggleKey() + ", environmentKey=" + this.getEnvironmentKey() + ", projectKey=" + this.getProjectKey() + ", trackAccessEvents=" + this.isTrackAccessEvents() + ", trackStartTime=" + this.getTrackStartTime() + ", trackEndTime=" + this.getTrackEndTime() + ", lastModified=" + this.getLastModified() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @Generated
    public static class ToggleControlConfBuilder {
        @Generated
        private String toggleKey;
        @Generated
        private String environmentKey;
        @Generated
        private String projectKey;
        @Generated
        private boolean trackAccessEvents;
        @Generated
        private Date trackStartTime;
        @Generated
        private Date trackEndTime;
        @Generated
        private Date lastModified;
        @Generated
        private Long organizationId;

        @Generated
        ToggleControlConfBuilder() {
        }

        @Generated
        public ToggleControlConfBuilder toggleKey(String toggleKey) {
            this.toggleKey = toggleKey;
            return this;
        }

        @Generated
        public ToggleControlConfBuilder environmentKey(String environmentKey) {
            this.environmentKey = environmentKey;
            return this;
        }

        @Generated
        public ToggleControlConfBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Generated
        public ToggleControlConfBuilder trackAccessEvents(boolean trackAccessEvents) {
            this.trackAccessEvents = trackAccessEvents;
            return this;
        }

        @Generated
        public ToggleControlConfBuilder trackStartTime(Date trackStartTime) {
            this.trackStartTime = trackStartTime;
            return this;
        }

        @Generated
        public ToggleControlConfBuilder trackEndTime(Date trackEndTime) {
            this.trackEndTime = trackEndTime;
            return this;
        }

        @Generated
        public ToggleControlConfBuilder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Generated
        public ToggleControlConfBuilder organizationId(Long organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public ToggleControlConf build() {
            return new ToggleControlConf(this.toggleKey, this.environmentKey, this.projectKey, this.trackAccessEvents, this.trackStartTime, this.trackEndTime, this.lastModified, this.organizationId);
        }

        @Generated
        public String toString() {
            return "ToggleControlConf.ToggleControlConfBuilder(toggleKey=" + this.toggleKey + ", environmentKey=" + this.environmentKey + ", projectKey=" + this.projectKey + ", trackAccessEvents=" + this.trackAccessEvents + ", trackStartTime=" + this.trackStartTime + ", trackEndTime=" + this.trackEndTime + ", lastModified=" + this.lastModified + ", organizationId=" + this.organizationId + ")";
        }
    }
}

